<?php

/**
 * @package     Joomla.Site
 * @subpackage  Templates.cassiopeia
 *
 * @copyright   (C) 2017 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
HTMLHelper::_('jquery.framework');

/** @var Joomla\CMS\Document\HtmlDocument $this */

$app   = Factory::getApplication();
$input = $app->getInput();
$wa    = $this->getWebAssetManager();

// Browsers support SVG favicons
// $this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon.svg', '', [], true, 1), 'icon', 'rel', ['type' => 'image/svg+xml']);
$this->addHeadLink(HTMLHelper::_('image', 'favicon.ico', '', [], true, 1), 'alternate icon', 'rel', ['type' => 'image/vnd.microsoft.icon']);
// $this->addHeadLink(HTMLHelper::_('image', 'joomla-favicon-pinned.svg', '', [], true, 1), 'mask-icon', 'rel', ['color' => '#000']);

// Detecting Active Variables
$option   = $input->getCmd('option', '');
$view     = $input->getCmd('view', '');
$layout   = $input->getCmd('layout', '');
$task     = $input->getCmd('task', '');
$itemid   = $input->getCmd('Itemid', '');
$sitename = htmlspecialchars($app->get('sitename'), ENT_QUOTES, 'UTF-8');
$menu     = $app->getMenu()->getActive();
$pageclass = $menu !== null ? $menu->getParams()->get('pageclass_sfx', '') : '';

// Color Theme
$paramsColorName = $this->params->get('colorName', 'colors_standard');
$assetColorName  = 'theme.' . $paramsColorName;
$wa->registerAndUseStyle($assetColorName, 'media/templates/site/cassiopeia/css/global/' . $paramsColorName . '.css');

// Use a font scheme if set in the template style options
$paramsFontScheme = $this->params->get('useFontScheme', false);
$fontStyles       = '';

if ($paramsFontScheme) {
    if (stripos($paramsFontScheme, 'https://') === 0) {
        $this->getPreloadManager()->preconnect('https://fonts.googleapis.com/', ['crossorigin' => 'anonymous']);
        $this->getPreloadManager()->preconnect('https://fonts.gstatic.com/', ['crossorigin' => 'anonymous']);
        $this->getPreloadManager()->preload($paramsFontScheme, ['as' => 'style', 'crossorigin' => 'anonymous']);
        $wa->registerAndUseStyle('fontscheme.current', $paramsFontScheme, [], ['media' => 'print', 'rel' => 'lazy-stylesheet', 'onload' => 'this.media=\'all\'', 'crossorigin' => 'anonymous']);

        if (preg_match_all('/family=([^?:]*):/i', $paramsFontScheme, $matches) > 0) {
            $fontStyles = '--cassiopeia-font-family-body: "' . str_replace('+', ' ', $matches[1][0]) . '", sans-serif;
			--cassiopeia-font-family-headings: "' . str_replace('+', ' ', isset($matches[1][1]) ? $matches[1][1] : $matches[1][0]) . '", sans-serif;
			--cassiopeia-font-weight-normal: 400;
			--cassiopeia-font-weight-headings: 700;';
        }
    } else {
        $wa->registerAndUseStyle('fontscheme.current', $paramsFontScheme, ['version' => 'auto'], ['media' => 'print', 'rel' => 'lazy-stylesheet', 'onload' => 'this.media=\'all\'']);
        $this->getPreloadManager()->preload($wa->getAsset('style', 'fontscheme.current')->getUri() . '?' . $this->getMediaVersion(), ['as' => 'style']);
    }
}

// Enable assets
$wa->usePreset('template.cassiopeia.' . ($this->direction === 'rtl' ? 'rtl' : 'ltr'))
    ->useStyle('template.active.language')
    ->useStyle('template.user')
    ->useScript('template.user')
    ->addInlineStyle(":root {
		--hue: 214;
		--template-bg-light: #f0f4fb;
		--template-text-dark: #495057;
		--template-text-light: #ffffff;
		--template-link-color: #2a69b8;
		--template-special-color: #001B4C;
		$fontStyles
	}");

// Override 'template.active' asset to set correct ltr/rtl dependency
$wa->registerStyle('template.active', '', [], [], ['template.cassiopeia.' . ($this->direction === 'rtl' ? 'rtl' : 'ltr')]);

// Logo file or site title param
if ($this->params->get('logoFile')) {
    $logo = HTMLHelper::_('image', Uri::root(false) . htmlspecialchars($this->params->get('logoFile'), ENT_QUOTES), $sitename, ['loading' => 'eager', 'decoding' => 'async'], false, 0);
} elseif ($this->params->get('siteTitle')) {
    $logo = '<span title="' . $sitename . '">' . htmlspecialchars($this->params->get('siteTitle'), ENT_COMPAT, 'UTF-8') . '</span>';
} else {
    $logo = HTMLHelper::_('image', 'logo.svg', $sitename, ['class' => 'logo d-inline-block', 'loading' => 'eager', 'decoding' => 'async'], true, 0);
}

$hasClass = '';

if ($this->countModules('sidebar-left', true)) {
    $hasClass .= ' has-sidebar-left';
}

if ($this->countModules('sidebar-right', true)) {
    $hasClass .= ' has-sidebar-right';
}

// Container
$wrapper = $this->params->get('fluidContainer') ? 'wrapper-fluid' : 'wrapper-static';

$this->setMetaData('viewport', 'width=device-width, initial-scale=1');

$stickyHeader = $this->params->get('stickyHeader') ? 'position-sticky sticky-top' : '';

// Defer fontawesome for increased performance. Once the page is loaded javascript changes it to a stylesheet.
$wa->getAsset('style', 'fontawesome')->setAttribute('rel', 'lazy-stylesheet');
?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">
<head>
    <jdoc:include type="metas" />
    <jdoc:include type="styles" />
    <jdoc:include type="scripts" />
    <script src="https://kit.fontawesome.com/bcf6a149fb.js" crossorigin="anonymous"></script>
<?php $this->setGenerator(''); ?>
</head>
<div id="preloader" style="/* display: none; */">

  <div class="whirlpool"></div>

</div>
<body class="site <?php echo $option
    . ' ' . $wrapper
    . ' view-' . $view
    . ($layout ? ' layout-' . $layout : ' no-layout')
    . ($task ? ' task-' . $task : ' no-task')
    . ($itemid ? ' itemid-' . $itemid : '')
    . ($pageclass ? ' ' . $pageclass : '')
    . $hasClass
    . ($this->direction == 'rtl' ? ' rtl' : '');
?>">
<header class="header container-header full-width<?php echo $stickyHeader ? ' ' . $stickyHeader : ''; ?>">

    <?php if ($this->countModules('topbar')) : ?>
        <div class="container-topbar top-info">
            <div class="grid-child container-nav">
                <jdoc:include type="modules" name="topbar" style="none" />
                <jdoc:include type="modules" name="social-lang" style="none" />
            </div>
        </div>
    <?php endif; ?>

    <?php if ($this->params->get('brand', 1)) : ?>
        <div class="grid-child top-logo">
            <div class="navbar-brand">
                <a class="brand-logo" href="<?php echo $this->baseurl; ?>/">
                    <?php echo $logo; ?>
                </a>
                <?php if ($this->params->get('siteDescription')) : ?>
                    <div class="site-description"><?php echo htmlspecialchars($this->params->get('siteDescription')); ?></div>
                <?php endif; ?>
            </div>
            <jdoc:include type="modules" name="top-contact" style="none" />
        </div>
    <?php endif; ?>

    <?php if ($this->countModules('menu', true) || $this->countModules('search', true)) : ?>
        <div class="menu-search">
            <div class="grid-child container-nav">
                <?php if ($this->countModules('menu', true)) : ?>
                    <jdoc:include type="modules" name="menu" style="none" />
                <?php endif; ?>
                <?php if ($this->countModules('search', true)) : ?>
                    <div class="container-search">
                        <jdoc:include type="modules" name="search" style="none" />
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
</header>

<div class="site-grid body-banner">
    <?php if ($this->countModules('banner', true)) : ?>
        <div class="container-banner full-width">
            <jdoc:include type="modules" name="banner" style="none" />
        </div>
    <?php endif; ?>
</div>
<div class="breadcrumbs">
    <?php if ($this->countModules('breadcrumbs', true)) : ?>
        <div class="grid-child">
            <jdoc:include type="modules" name="breadcrumbs" style="none" />
        </div>
    <?php endif; ?>
</div>
<div class="site-grid body-main_content">
    <div class="grid-child container-component main_content">
        <jdoc:include type="modules" name="main-top" style="card" />
        <jdoc:include type="message" />
        <main>
        <jdoc:include type="component" />
        </main>
        <jdoc:include type="modules" name="main-bottom" style="none" />
    </div>
</div>

<div class="container-section-a">
    <jdoc:include type="modules" name="section-a-title" style="none" />
    <div class="grid-child container-nav">
        <?php if ($this->countModules('section-a', true)) : ?>
            <jdoc:include type="modules" name="section-a" style="none" />
        <?php endif; ?>
    </div>
</div>

<div class="container-section-b">
    <jdoc:include type="modules" name="section-b-title" style="none" />
    <div class="grid-child container">
        <?php if ($this->countModules('section-b', true)) : ?>
            <jdoc:include type="modules" name="section-b" style="none" />
        <?php endif; ?>
    </div>
</div>

<div class="container-section-c">
    <jdoc:include type="modules" name="section-c-title" style="none" />
    <div class="grid-child container">
        <?php if ($this->countModules('section-c', true)) : ?>
            <jdoc:include type="modules" name="section-c" style="none" />
        <?php endif; ?>
    </div>
</div>

<div class="container-section-d">
    <jdoc:include type="modules" name="section-d-title" style="none" />
    <div class="grid-child container">
        <?php if ($this->countModules('section-d', true)) : ?>
            <jdoc:include type="modules" name="section-d" style="none" />
        <?php endif; ?>
    </div>
</div>

<div class="container-section-e">
    <div class="grid-child container">
        <?php if ($this->countModules('section-e', true)) : ?>
            <jdoc:include type="modules" name="section-e" style="none" />
        <?php endif; ?>
    </div>
</div>

<?php if ($this->countModules('footer-1', true) || $this->countModules('footer-2', true) || $this->countModules('footer-3', true) || $this->countModules('footer-4', true) || $this->countModules('footer-5', true) || $this->countModules('footer-6', true) || $this->countModules('footer-7', true)) : ?>
<footer class="container-footer footer full-width">
    <div class="grid-child container-nav">
        <?php if ($this->countModules('footer-1', true)) : ?>
            <div class="grid-child">
                <jdoc:include type="modules" name="footer-1" style="card" />
            </div>
        <?php endif; ?>

        <?php if ($this->countModules('footer-2', true)) : ?>
            <div class="grid-child">
                <jdoc:include type="modules" name="footer-2" style="card" />
            </div>
        <?php endif; ?>

        <?php if ($this->countModules('footer-3', true)) : ?>
            <div class="grid-child">
                <jdoc:include type="modules" name="footer-3" style="card" />
            </div>
        <?php endif; ?>
    </div>

    <?php if ($this->countModules('footer-7', true)) : ?>
        <div class="copyright">
            <div class="grid-child">
                <jdoc:include type="modules" name="footer-7" style="card" />
            </div>
        </div>
    <?php endif; ?>
</footer>
<?php endif; ?>

<?php if ($this->params->get('backTop') == 1) : ?>
    <a href="#top" id="back-top" class="back-to-top-link" aria-label="<?php echo Text::_('TPL_My-Theme_BACKTOTOP'); ?>">
        <span class="icon-arrow-up icon-fw" aria-hidden="true"></span>
    </a>
<?php endif; ?>

<jdoc:include type="modules" name="debug" style="none" />
</body>
</html>
