<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Language\Multilanguage;

$modId = 'mod-carousel' . $module->id;
$app = Factory::getApplication();
$menu = $app->getMenu()->getActive();

// Look for the active menu item
$lang = Factory::getLanguage();
if (Multilanguage::isEnabled()) {
	$home = $app->getMenu()->getDefault($lang->getTag());
} else {
	$home = $app->getMenu()->getDefault();
}

$hidden = "";
if (!$params->get('showTextOnImage')) {
	$hidden = " hidden ";
}
?>


<?php if ($menu === $home && $params->get('onlyHomepage')) : ?>
<div id="<?php echo $modId; ?>" class="mod-custom custom">
	<div class="carousel slide" data-bs-ride="carousel" id="carouselHeaderCaptions" data-interval="900">
		<div class="carousel-inner">
			<?php foreach ($params->get('carouselimages') as $key => $carouselimage) : ?>
				<?php if ($params->get('bigText')) : ?>
			<div class="carousel-item carousel-item1 <?php echo (str_replace("carouselimages", "", $key) == '0') ? ' active ' : ''; ?> bg bg-<?php echo str_replace("carouselimages", "", $key) ?>">
				<div class="<?php echo $hidden; ?> carousel-caption carousel-caption1">
					<h3> <?php echo $carouselimage->heading; ?></h3>
					<p><?php echo $carouselimage->text; ?></p>
					<a class="btn btn-secondary"
						href="<?php echo Uri::root() . $carouselimage->link; ?>"><?php echo Text::_('MOD_CAROUSEL_MORE'); ?></a>
				</div>
			</div>
				<?php endif; ?>

				<?php if (!$params->get('bigText')) : ?>
			<div class="carousel-item carousel-item1 <?php echo (str_replace("carouselimages", "", $key) == '0') ? ' active ' : ''; ?> bg bg-<?php echo str_replace("carouselimages", "", $key) ?>">
				<div class="<?php echo $hidden; ?> carousel-caption carousel-caption1">
					<p>
						<?php echo $carouselimage->heading; ?> <?php echo $carouselimage->text; ?>
						<a class="btn btn-primary"
							href="<?php echo Uri::root() . $carouselimage->link; ?>"><?php echo Text::_('MOD_CAROUSEL_MORE'); ?>
						</a>
					</p>
				</div>
			</div>
				<?php endif; ?>

			<?php endforeach; ?>
		</div>
		<button type="button" class="carousel-control-prev" data-bs-target="#carouselHeaderCaptions" data-bs-slide="prev"> 
				<span class="carousel-control-prev-icon" aria-hidden="true"></span> 
				<span class="visually-hidden">Previous</span> 
			</button> 
			<button type="button" class="carousel-control-next" data-bs-target="#carouselHeaderCaptions" data-bs-slide="next"> 
				<span class="carousel-control-next-icon" aria-hidden="true"></span> 
				<span class="visually-hidden">Next</span> 
			</button>
	</div>
</div>
<?php endif; ?>

<!--
Stylesheet for user.css
<style>
:root {
  --cassiopeia-color-primary-rgb: 85,152,55;
}
</style>
-->

<style>

<?php echo $params->get('optionalCSS', ''); ?>

<?php foreach ($params->get('carouselimages') as $key => $carouselimage) :
	?>.bg-<?php echo str_replace("carouselimages", "", $key) ?> {
	background-image: url("<?php echo Uri::root(); ?><?php echo $carouselimage->file; ?>");
}

<?php endforeach;

?>.carousel-item {
	min-height: <?php echo $params->get('minheight') ?>px;
}

.carousel-caption {
	z-index: 2;
	background-color: rgba(var(--cassiopeia-color-primary-rgb), 0.75);
}

.bg {
	-webkit-background-size: cover;
	background-size: cover;
}

<?php if ($carouselimage->fileup768 != '') : ?>
@media only screen and (min-width: 768px) {
	<?php foreach ($params->get('carouselimages') as $key => $carouselimage) :?>
		.bg-<?php echo str_replace("carouselimages", "", $key) ?> {
			background-image: url("<?php echo Uri::root(); ?><?php echo $carouselimage->fileup768; ?>");
		}
	<?php endforeach; ?>
}
<?php endif; ?>

@media only screen and (min-width: <?php echo $params->get('hideImageAt', 768); ?>px) and (max-width: <?php echo $params->get('hideTextAt', 1200); ?>px) {
	.carousel-caption {
		display: none;
	}
}

@media only screen and (max-width: <?php echo $params->get('hideImageAt', 768); ?>px) {
	#<?php echo $modId;

	?> {
		display: none;
	}

	.carousel {
		display: none;
	}
}
</style>