<?php
/**
 * Visforms message date class
 *
 * @author       Aicha Vack
 * @package      Joomla.Site
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Language\Text;

class VisformsMessageDate extends VisformsMessage
{

	public function __construct($name, $args) {
		parent::__construct($name, $args);
		$this->text = 'COM_VISFORMS_FIELD_DATE_FORMAT';
		$this->args = $args;
	}

	protected function setMessage() {
		$format = (isset($this->args['format'])) ? $this->args['format'] : '';
		$message = Text::sprintf($this->text, $this->name, $format);
		return $message;
	}
}