<?php
/**
 * viscpanel default view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6 
 */

//no direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Session\Session;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Component\ComponentHelper;

HTMLHelper::_('bootstrap.framework');
$token             = Session::getFormToken();
$isSub             = VisformsAEF::checkAEF(VisformsAEF::$subscription);
$component         = ComponentHelper::getComponent('com_visforms');
$dlID = $component->params->get('downloadid', '');
$demoFormInstalled = $component->params->get('demoFormInstalled', '');
$extensionTypeTag  = ($isSub) ? 'COM_VISFORMS_SUBSCRIPTION' : 'COM_VISFORMS_PAYED_EXTENSION';

$js = <<<JS
jQuery(document).ready(function() {
    // initialize
});
var visDebugger = {
    checkInstallation: function () {
        console.log('checkInstallation called');
        // show the waiting icon during the request
        let donat = '.icon_ajax-call-wait_check-installation';
        visHelperAsync.startWaitDonut(donat);
        // data to send
        let fid = 123;
        let count = 900;
        var data = 'data=' + JSON.stringify({ fid: fid, count: count, "{$token}" : 1});
        // send form data
        jQuery.ajax({
            type: 'POST',
            url: 'index.php?option=com_visforms&task=visdebugger.checkInstallation',
            data: data,
            success: function(data, textStatus, jqXHR) {
                // hide the waiting icon
                visHelperAsync.stopWaitDonut(donat);
                window.setTimeout(function () {
                    alert(data.message);
                }, 1);
            },
            error: function(jqXHR, textStatus, errorThrown) {
                // hide the waiting icon
                visHelperAsync.stopWaitDonut(donat);
                // give error feedback
                visHelper.showError(jqXHR.responseText, errorThrown);
            },
            dataType: 'json',
            async: true
        });
    },
};
var visHelper = {
    showError: function (responseText, errorThrown) {
        var dlg = jQuery('#ajax-modal-error-dialog');
        if(responseText.startsWith('<!DOC')) {
            jQuery(dlg).find('.modal-body').html(errorThrown);
            jQuery(dlg).find('.modal-sub-title').html('');
        }
        else {
            jQuery(dlg).find('.modal-body').html(responseText);
            jQuery(dlg).find('.modal-sub-title').html('Text Status: ' + errorThrown);
        }
        jQuery(dlg).modal('show');
    }
};
var visHelperAsync = {
    startWaitDonut: function (waitDonut) {
        jQuery(waitDonut).show();
    },
    stopWaitDonut: function (waitDonut) {
        if(null == waitDonut) {
            jQuery('.icon_ajax-call-wait').hide();
        }
        else {
            jQuery(waitDonut).hide();
        }
    }
};
JS;
$this->document->addScriptDeclaration($js);

$css = <<<CSS
td .form-control {
    width: 100%;
}
CSS;
$this->document->addStyleDeclaration($css);
?>

<div class="row"><?php
if (!empty( $this->sidebar)) { ?>
<div id="j-sidebar-container" class="col-md-3 col-xl-2">
<?php echo $this->sidebar; ?>
</div><?php } ?>
<div class="<?php if (!empty($this->sidebar)) {echo 'col-md-9 col-xl-10'; } else { echo 'col-12'; } ?>">
<div id="j-main-container" class="j-main-container">
<div id="vfdebugger">
<!--    -->
<div class="row">
    <div class="col-lg-6 mt-3">
        <h1><?php echo Text::_('COM_VISFORMS_SUBMENU_DEBUGGER'); ?></h1>
    </div>
</div>
<div class="row">
    <div class="col-lg-6 mt-3">
        <button data-bs-content="Add new field to form" onclick="visDebugger.checkInstallation();" class="btn btn-small btn-info btn-add-field hasPopover" data-bs-original-title="" title="">Check Installation</button>
    </div>
    <div class="row-fluid btns-create-form"> <?php
        $tag = 'check-installation';
		echo (new JLayoutFile('div.icon_ajax_call_wait'))->render($tag); ?>
    </div>
</div>
<?php echo HTMLHelper::_('visforms.creditsBackend');
echo (new JLayoutFile('div.ajax_modal_error_dialog'))->render(); ?>
</div>
</div>
</div>

