<?php
/**
 * viscpanel view for Visforms
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Component\Visforms\Administrator\View\Visdebugger;

defined('_JEXEC') or die('Direct Access to this location is not allowed.');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Toolbar\Toolbar;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Component\ComponentHelper;

/**
 * viscpanel view
 *
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @since        Joomla 1.6
 */
class HtmlView extends BaseHtmlView {

	public function __construct(array $config) {
		parent::__construct($config);
	}

	function display($tpl = null) {
		\VisformsHelper::addSubmenu('visdebugger');
		$this->addToolbar();
		parent::display($tpl);
	}

	protected function addToolbar() {
		\VisformsHelper::addCommonViewStyleCss();
		ToolbarHelper::title(Text::_('COM_VISFORMS') . ' - ' . Text::_('COM_VISFORMS_SUBMENU_DEBUGGER'), 'visform');
		// Options button.
		if (Factory::getApplication()->getIdentity()->authorise('core.admin', 'com_visforms')) {
			ToolbarHelper::preferences('com_visforms');
		}
	}
}