<?php
/**
 * Visforms controller for VisCpanel
 *
 * @author       Aicha Vack
 * @package      Joomla.Administrator
 * @subpackage   com_visforms
 * @link         https://www.vi-solutions.de
 * @license      GNU General Public License version 2 or later; see license.txt
 * @copyright    2012 vi-solutions
 * @since        Joomla 1.6
 */

namespace Visolutions\Component\Visforms\Administrator\Controller;

defined('_JEXEC') or die('Direct Access to this location is not allowed.');

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Filesystem\File;
use Visolutions\Component\Visforms\Administrator\Model\VisdataModel;

class VisdebuggerController extends ItemControllerBase
{
    function __construct($config = array(), MVCFactoryInterface $factory = null, $app = null, $input = null){
        parent::__construct($config, $factory, $app, $input);
    }

	public function checkInstallation() {
		// get the data
		if (!$this->checkAjaxSessionToken()) {
			$message = Text::_("COM_VISFORMS_AJAX_INVALID_TOKEN");
			$success = false;
		}
		else {
			$message = 'message text';
			$success = true;
		}
		// return success
		$buffer = ob_get_contents();
		ob_clean();
		$response = array("success" => $success, 'message' => $message);
		$document = $this->app->getDocument();
		$document->setMimeEncoding('application/json');
		echo json_encode($response);
		$this->app->close();
	}
}